% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC_ordinals.R
\name{prep_ordinal}
\alias{prep_ordinal}
\title{Ordinal x-axis by grouping}
\usage{
prep_ordinal(dat, x_axis, groupings = NULL, prob_disc = FALSE)
}
\arguments{
\item{dat}{Discounting data tibble}

\item{x_axis}{Delays/probabilities/social distance variable}

\item{groupings}{Variables for grouping (e.g., subject, expeirmental group)}

\item{prob_disc}{Boolean for probability discounting, if set to true
function will calculate ordinals based on descending \code{x_axis}
values which would be in line with increasing odds against.}
}
\value{
Tibble that has ordinal values for each \code{x_axis} value
based on all possible \code{x_axis} values. Output tibble is arranged
in the same order as original tibble.
}
\description{
Helper function to create ordinal values for x-axis variable.
This helper function is designed to be used if the x-axis values
are identical across every set of indifference points or if you
desire ordinal x-axis values by subject. For the second case,
if one subject was exposed to delays of 1 day and 1 month and a
second subject was exposed to delays of 1 week and 1 month. In
such a case, \code{prep_ordinal()} would return ordinal delays of (1, 2)
for subject 1 and ordinal delays of (1, 2) for subject 2. If zeroes exist,
will code as ordinal 0.
}
\examples{
library(dplyr)

PD <- tibble(
  prob = c(
    c(.05, 1 / 100, 1 / 300, 1 / 750, 1 / 1000, 1 / 3000),
    c(.1, 1 / 100, 1 / 300, 1 / 750, 1 / 1000, 1 / 4000)
  ),
  indiff = c(c(95, 75, 50, 20, 5, 1), c(95, 75, 50, 20, 5, 1) + .25),
  sub = c(rep(1, 6), rep(2, 6))
)

# Scramble data to demonstrate preserved original order
PD <- PD \%>\%
  mutate(scramble = rnorm(NROW(PD), 0, 1)) \%>\%
  arrange(scramble)

PD

prep_ordinal(PD, "prob", prob_disc = TRUE, "sub")
}
