% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-progress.R
\name{handler_dipsaus_progress}
\alias{handler_dipsaus_progress}
\title{Progress-bar Handler}
\usage{
handler_dipsaus_progress(
  title = getOption("dipsaus.progressr.title", "Progress"),
  intrusiveness = getOption("progressr.intrusiveness.gui", 1),
  target = if (is.null(shiny::getDefaultReactiveDomain())) "terminal" else "gui",
  enable = interactive() || shiny_is_running(),
  ...
)
}
\arguments{
\item{title}{default title of \code{\link{progress2}}}

\item{intrusiveness}{A non-negative scalar on how intrusive
(disruptive) the reporter to the user}

\item{target}{where progression updates are rendered}

\item{enable}{whether the progress should be reported}

\item{...}{passed to \code{\link[progressr]{make_progression_handler}}}
}
\description{
Handler for \code{\link{progress2}} to support
\code{progressr::handlers}. See examples for detailed use case
}
\examples{


library(progressr)
library(shiny)
library(future)

## ------------------------------ Setup! -------------------------------
handlers(handler_dipsaus_progress())

# ------------------------------ A simple usage ------------------------
xs <- 1:5
handlers(handler_dipsaus_progress())
with_progress({
  p <- progressor(along = xs)
  y <- lapply(xs, function(x) {
    p(sprintf("x=\%g", x))
    Sys.sleep(0.1)
    sqrt(x)
  })
})

# ------------------------ A future.apply case -------------------------
plan(sequential)
# test it yourself with plan(multisession)

handlers(handler_dipsaus_progress())
with_progress({
  p <- progressor(along = xs)
  y <- future.apply::future_lapply(xs, function(x) {
    p(sprintf("x=\%g", x))
    Sys.sleep(0.1)
    sqrt(x)
  })
})

# ------------------------ A shiny case --------------------------------

ui <- fluidPage(
  actionButton('ok', 'Run Demo')
)

server <- function(input, output, session) {
  handlers(handler_dipsaus_progress())
  make_forked_clusters()

  observeEvent(input$ok, {
    with_progress({
      p <- progressor(along = 1:100)
      y <- future.apply::future_lapply(1:100, function(x) {
        p(sprintf("Input \%d|Result \%d", x, x+1))
        Sys.sleep(1)
        x+1
      })
    })
  })
}

if(interactive()){
  shinyApp(ui, server)
}



}
