% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsApi2df.R
\name{dsApi2df}
\alias{dsApi2df}
\title{Convert json dimensions bibliographic data into a dataframe}
\usage{
dsApi2df(P, format = "bibliometrix")
}
\arguments{
\item{P}{is a list in json dimensions structure downloaded using the function \code{dsApiRequest}.}

\item{format}{is a character. If \code{format = "bibliometrix"} data will be converted in the bibliometrix complatible data format. 
If \code{format = "raw"} data will save in a data frame without any other data editing procedure.}
}
\value{
a dataframe containing bibliographic records or grants information.

To obtain a free access to Dimenions API fro no commercial use, please visit: \href{https://ds.digital-science.com/NoCostAgreement}{https://ds.digital-science.com/NoCostAgreement}

For more extensive information about dimensions API, please visit: \href{https://www.dimensions.ai/dimensions-apis/}{https://www.dimensions.ai/dimensions-apis/}

For more extensive information about bibliometrix R packagee, please visit: \href{https://www.bibliometrix.org}{https://www.bibliometrix.org}
}
\description{
It converts dimensions data, downloaded using DSL API, into a dataframe
}
\examples{


# Example 1: Querying a collection of publications

\dontrun{
token <- dsAuth(username = "my.email@my.domain", password = "mypassword")
query <- dsQueryBuild(item = "publications", words = "bibliometric*", 
                       type = "article", categories = "management", 
                       start_year=1980,end_year = 2020)
D <- dsApiRequest(token = token, query = query, limit = 50000)
M <- dsApi2df(D)
}

# Example 2: Querying a collection of grants

\dontrun{
token <- dsAuth(username = "my.email@my.domain", password = "mypassword")
query <- dsQueryBuild(item = "grants", words = "bibliometric*", 
                       type = "", categories = "management", 
                       start_year=1980,end_year = 2020)
D <- dsApiRequest(token = token, query = query, limit = 50000)
M <- dsApi2df(D)
}

}
\seealso{
\code{\link{dsApiRequest}}

\code{\link{dsAuth}}

\code{\link{dsQueryBuild}}
}
