% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slr.R
\name{precip_slr}
\alias{precip_slr}
\title{Estimate precipitation with simple linear regression}
\usage{
precip_slr(
  data,
  regression = "Peppe2018",
  slope = NULL,
  constant = NULL,
  error = NULL
)
}
\arguments{
\item{data}{A data frame that must include the columns "morphotype", "leaf_area", and "specimen_number".
Must be species level data.}

\item{regression}{A string representing one of the following pre-loaded regressions:
\itemize{
\item "Peppe2018" - for global precipitation estimates
\item "Peppe2011" - The Americas, Japan, and Oceania
\item "Jacobs2002" - Africa
\item "Wilf1998" - The Americas and Africa
}}

\item{slope}{Slope, if using a custom regression}

\item{constant}{Constant, if using a custom regression}

\item{error}{Standard error, if using a custom regression}
}
\value{
A table with MAP estimates for each site
}
\description{
\code{precip_slr()} will produce estimates of mean annual precipitation and standard error
using leaf area analysis.
}
\examples{
precip_slr(McAbeeExample, regression = "Peppe2011")
}
\references{
\itemize{
\item Peppe, D. J., Baumgartner, A., Flynn, A., & Blonder, B. (2018). Reconstructing paleoclimate and paleoecology using fossil leaves. Methods in paleoecology: Reconstructing Cenozoic terrestrial environments and ecological communities, 289-317.
\item Peppe, D.J., Royer, D.L., Cariglino, B., Oliver, S.Y., Newman, S., Leight, E., Enikolopov, G., Fernandez-Burgos, M., Herrera, F., Adams, J.M., Correa, E., Currano, E.D., Erickson, J.M., Hinojosa, L.F., Hoganson, J.W., Iglesias, A., Jaramillo, C.A., Johnson, K.R., Jordan, G.J., Kraft, N.J.B., Lovelock, E.C., Lusk, C.H., Niinemets, Ü., Peñuelas, J., Rapson, G., Wing, S.L. and Wright, I.J. (2011), Sensitivity of leaf size and shape to climate: global patterns and paleoclimatic applications. New Phytologist, 190: 724-739. https://doi.org/10.1111/j.1469-8137.2010.03615.x
\item Jacobs, B. F. (2002). Estimation of low-latitude paleoclimates using fossil angiosperm leaves: examples from the Miocene Tugen Hills, Kenya. Paleobiology, 28, 399–421.
\item Wilf, P. (2008). Fossil angiosperm leaves: paleobotany’s difficult children prove themselves. Paleontological Society Papers, 14, 319–333.
}
}
