% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr.btest.R
\name{distr.btest}
\alias{distr.btest}
\title{Bayesian Test of Digits against a Reference Distribution}
\usage{
distr.btest(x, check = 'first', reference = 'benford', 
            alpha = NULL, BF10 = TRUE, log = FALSE)
}
\arguments{
\item{x}{a numeric vector.}

\item{check}{location of the digits to analyze. Can be \code{first}, \code{firsttwo}, or \code{last}.}

\item{reference}{which character string given the reference distribution for the digits, or a vector of probabilities for each digit. Can be \code{benford} for Benford's law, \code{uniform} for the uniform distribution. An error is given if any entry of \code{reference} is negative. Probabilities that do not sum to one are normalized.}

\item{alpha}{a numeric vector containing the prior parameters for the Dirichlet distribution on the digit categories.}

\item{BF10}{logical. Whether to compute the Bayes factor in favor of the alternative hypothesis (BF10) or the null hypothesis (BF01).}

\item{log}{logical. Whether to return the logarithm of the Bayes factor.}
}
\value{
An object of class \code{dt.distr} containing:

\item{observed}{the observed counts.}
\item{expected}{the expected counts under the null hypothesis.}
\item{n}{the number of observations in \code{x}.}
\item{statistic}{the value the chi-squared test statistic.}
\item{parameter}{the degrees of freedom of the approximate chi-squared distribution of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{check}{checked digits.}
\item{digits}{vector of digits.}
\item{reference}{reference distribution}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
This function extracts and performs a Bayesian test of the distribution of (leading) digits in a vector against a reference distribution. By default, the distribution of leading digits is checked against Benford's law.
}
\details{
Benford's law is defined as \eqn{p(d) = log10(1/d)}. The uniform distribution is defined as \eqn{p(d) = 1/d}.

The Bayes Factor \eqn{BF_{10}} quantifies how much more likely the data are to be observed under \eqn{H_{1}}: the digits are not distributed according to the reference distribution than under \eqn{H_{0}}: the digits are distributed according to the reference distribution. Therefore, \eqn{BF_{10}} can be interpreted as the relative support in the observed data for \eqn{H_{1}} versus \eqn{H_{0}}. If \eqn{BF_{10}} is 1, there is no preference for either \eqn{H_{1}} or \eqn{H_{0}}. If \eqn{BF_{10}} is larger than 1, \eqn{H_{1}} is preferred. If \eqn{BF_{10}} is between 0 and 1, \eqn{H_{0}} is preferred. The Bayes factor is calculated using the Savage-Dickey density ratio.
}
\examples{
set.seed(1)
x <- rnorm(100)

# Bayesian digit analysis against Benford's law
distr.btest(x, check = 'first', reference = 'benford')

# Bayesian digit analysis against Benford's law, custom prior
distr.btest(x, check = 'first', reference = 'benford', alpha = 9:1)

# Bayesian digit analysis against custom distribution
distr.btest(x, check = 'last', reference = rep(1/9, 9))

}
\references{
Benford, F. (1938). The law of anomalous numbers. \emph{In Proceedings of the American Philosophical Society}, 551-572.
}
\seealso{
\code{\link{distr.test}} \code{\link{rv.test}}
}
\author{
Koen Derks, \email{k.derks@nyenrode.nl}
}
\keyword{Bayes}
\keyword{benford}
\keyword{distribution}
\keyword{factor}
