% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/privacy_params.R
\docType{class}
\name{DPParamsEps-class}
\alias{DPParamsEps-class}
\alias{DPParamsEps}
\alias{show,DPParamsEps-method}
\alias{getEpsilon,DPParamsEps-method}
\alias{setEpsilon<-,DPParamsEps-method}
\alias{toGamma,DPParamsEps,numeric-method}
\title{An S4 class for basic differential privacy parameters.}
\usage{
\S4method{show}{DPParamsEps}(object)

\S4method{getEpsilon}{DPParamsEps}(object)

\S4method{setEpsilon}{DPParamsEps}(object) <- value

\S4method{toGamma}{DPParamsEps,numeric}(object, gamma)
}
\arguments{
\item{object}{an object of class \code{\link{DPParamsEps}}.}

\item{value}{a scalar numeric \eqn{\epsilon}.}

\item{gamma}{a scalar numeric \eqn{\gamma}.}
}
\description{
An S4 base class representing the basic privacy parameter \eqn{\epsilon} in
differential privacy.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: automatically prints the object.

\item \code{getEpsilon}: getter for slot \code{epsilon}.

\item \code{setEpsilon<-}: setter for slot \code{epsilon}.

\item \code{toGamma}: returns object to corresponding instance of subclass
\code{\link{DPParamsGam}}.
}}

\section{Slots}{

\describe{
\item{\code{epsilon}}{positive scalar numeric privacy level.}
}}

\seealso{
\code{\link{DPParamsDel}} subclass for \eqn{(\epsilon,\delta)}
  relaxation, \code{\link{DPParamsGam}} subclass for random relaxation.
}
