% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace_mechanism.R
\docType{class}
\name{DPMechLaplace-class}
\alias{DPMechLaplace-class}
\alias{DPMechLaplace}
\alias{show,DPMechLaplace-method}
\title{An S4 class for the Laplace mechanism of differential privacy.}
\usage{
\S4method{show}{DPMechLaplace}(object)
}
\arguments{
\item{object}{an instance of class \code{DPMech}.}
}
\description{
A class that implements the basic Laplace mechanism of differential privacy,
for privatizing numeric vector releases.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: automatically prints the object.
}}

\section{Slots}{

\describe{
\item{\code{sensitivity}}{non-negative scalar numeric L1 target sensitivity.
Defaults to \code{Inf} for use with \code{sensitivitySampler()}.}

\item{\code{target}}{the target non-private function to be privatized, takes lists.
Defaults to a constant function. Laplace mechanism assumes functions that
release numeric vectors of fixed dimension \code{dims}.}

\item{\code{gammaSensitivity}}{\code{NA_real_} if inactive, or scalar in [0,1)
indicating that responses must be RDP with specific confidence.}

\item{\code{dims}}{positive scalar numeric dimension of responses. Defaults to
\code{NA_integer_} for use with \code{sensitivitySampler()} which can
probe \code{target} to determine dimension.}
}}

\references{
Cynthia Dwork, Frank McSherry, Kobbi Nissim, and Adam Smith.
  "Calibrating noise to sensitivity in private data analysis." In Theory of
  Cryptography Conference, pp. 265-284. Springer Berlin Heidelberg, 2006.
}
