% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanisms.R
\docType{class}
\name{DPMech-class}
\alias{DPMech-class}
\title{An S4 class for differentially-private mechanisms.}
\description{
A base class for representing output-perturbing mechanisms in differential
privacy. As this class is \code{VIRTUAL} it cannot be instantiated, but it can
be subclassed.
}
\section{Slots}{

\describe{
\item{\code{sensitivity}}{non-negative scalar numeric target sensitivity. Defaults
to \code{Inf} for use with \code{sensitivitySampler()}.}

\item{\code{target}}{the target non-private function to be privatized, takes lists.
Defaults to a constant function.}

\item{\code{gammaSensitivity}}{\code{NA_real_} if inactive, or scalar in [0,1)
indicating that responses must be RDP with specific confidence.}
}}

\references{
Cynthia Dwork, Frank McSherry, Kobbi Nissim, and Adam Smith.
  "Calibrating noise to sensitivity in private data analysis." In Theory of
  Cryptography Conference, pp. 265-284. Springer Berlin Heidelberg, 2006.
}
\seealso{
\code{\link{DPMechLaplace}} subclass for the Laplace mechanism.
}
