% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{getTESs}
\alias{getTESs}
\title{Compute TES}
\usage{
getTESs(ATM)
}
\arguments{
\item{ATM}{ATM structure as returned from the \code{\link{getATM}} method.}
}
\value{
The output will be a named list that contains the list of computed TESs, the noise thresholds at which they emerged and lastly the ATM structure.
}
\description{
Creates a structure for constructing the TES as described in "A Dynamical Model of Genetic Networks for Cell Differentiation
Villani M, Barbieri A, Serra R (2011) A Dynamical Model of Genetic Networks for Cell Differentiation. PLOS ONE 6(3): e17703. https://doi.org/10.1371/journal.pone.0017703"
}
\examples{

net <- BoolNet::generateRandomNKNetwork(10, 2)
attractors <- BoolNet::getAttractors(net)
ATM <- getATM(net, attractors)
getTESs(ATM)

}
