% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkkey.R
\name{checkkey}
\alias{checkkey}
\title{Check That A Dataframe Key Col Set Is Unique}
\usage{
checkkey(df, key_cols, verbose = FALSE)
}
\arguments{
\item{df}{a dataframe}

\item{key_cols}{vector of column names}

\item{verbose}{TRUE/FALSE should we print a message?}
}
\value{
TRUE if key cols have unique rows; FALSE if not
}
\description{
Checks that a provided vector of column names constitue a unique key (that is, no rows are duplicated) for a dataframe.
}
\examples{
irisint = iris
irisint$rownum = 1:nrow(irisint)
key_cols = c("rownum")
checkkey(irisint, key_cols, TRUE)
checkkey(irisint, "Species", TRUE)
}
