% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFoldEnrichment.R
\name{plotFoldEnrichment}
\alias{plotFoldEnrichment}
\title{plotFoldEnrichment}
\usage{
plotFoldEnrichment(de_res, pval, N)
}
\arguments{
\item{de_res}{Dataframe. Generated using \code{\link{diffEnrich}}}

\item{pval}{Numeric. Threshold for filtering pathways based on adjusted pvalue in de_res}

\item{N}{Numeric. Number of top pathways to plot after filtering based on pval}
}
\value{
ggplot object. If the user calls \code{plotFoldEnrich} and
assigns it to an object (see example) then no plot will print in viewer,
but if \code{plotFoldEnrich} is called without being assigned to an
object the plot will print to the viewer. Users can edit the ggplot object
as they would any other ggplot object (e.g. add title, theme, etc.).
}
\description{
This function uses the results generated using \code{\link{diffEnrich}}
to generate a bar plot describing the fold enrichment of a set of given KEGG
pathways stratified by their enrichment in list 1 or list 2. Users can plot
all pathways based on the adjusted p-value threshold used in \code{\link{diffEnrich}}
and the top N pathways sorted by the adjusted p-value threshold used in \code{\link{diffEnrich}}.
\code{plotFoldEnrich} returns a ggplot2 object so users can add additional
customizations.
}
\details{
This function generates a grouped bar plot using ggplot2 and the
ggnewscale package. KEGG pathways are plotted on the y-axis and fold
enrichment is plotted on the x-axis. each KEGG pathway has a bar plotting
its fold enrichment in list 1 (red) and its fold enrichment in list 2 (blue).
The transparency of the bars correspond to the adjusted p-value for the
pathway's enrichment in the given list. The p-value presented as text to the
right of each pair of bars is the adjusted p-value associated with the
differential enrichment of the pathway between the two lists, and the pathways
are ordered from top to bottom by this p-value (i.e. smallest p-value on top
of plot, and largest p-value on bottom of plot).
}
\examples{
\dontrun{
plot <- plotFoldEnrichment(de_res = diff_enrich, pval = 0.05, N = 5)
}
}
