% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/did_imputation.R
\name{did_imputation}
\alias{did_imputation}
\title{Borusyak, Jaravel, and Spiess (2021) Estimator}
\usage{
did_imputation(
  data,
  yname,
  gname,
  tname,
  idname,
  first_stage = NULL,
  wname = NULL,
  wtr = NULL,
  horizon = NULL,
  pretrends = NULL,
  cluster_var = NULL
)
}
\arguments{
\item{data}{A \code{data.frame}}

\item{yname}{String. Variable name for outcome. Use \code{fixest} c() syntax
for multiple lhs.}

\item{gname}{String. Variable name for unit-specific date of treatment
(never-treated should be zero or \code{NA}).}

\item{tname}{String. Variable name for calendar period.}

\item{idname}{String. Variable name for unique unit id.}

\item{first_stage}{Formula for Y(0).
Formula following \code{\link[fixest:feols]{fixest::feols}}.
Fixed effects specified after "\code{|}".
If not specified, then just unit and time fixed effects will be used.}

\item{wname}{String. Variable name for estimation weights of observations.
This is used in estimating Y(0) and also augments treatment effect weights.}

\item{wtr}{Character vector of treatment weight names
(see horizon for standard static and event-study weights)}

\item{horizon}{Integer vector of event_time or \code{TRUE}. This only applies if \code{wtr} is left
as \code{NULL}. if specified, weighted averages/sums of treatment effects will be
reported for each of these horizons separately (i.e. tau0 for the treatment
period, tau1 for one period after treatment, etc.).
If \code{TRUE}, all horizons are used.
If \code{wtr} and \code{horizon} are null, then the static treatment effect is calculated.}

\item{pretrends}{Integer vector or \code{TRUE}. Which pretrends to estimate.
If \code{TRUE}, all \code{pretrends} are used.}

\item{cluster_var}{String. Varaible name for clustering groups. If not
supplied, then \code{idname} is used as default.}
}
\value{
A \code{data.frame} containing treatment effect term, estimate, standard
error and confidence interval. This is in \code{tidy} format.
}
\description{
Treatment effect estimation and pre-trend testing in staggered adoption
diff-in-diff designs with an imputation approach of Borusyak, Jaravel, and
Spiess (2021)
}
\details{
The imputation-based estimator is a method of calculating treatment effects
in a difference-in-differences framework. The method estimates a model for
Y(0) using untreated/not-yet-treated observations and predicts Y(0) for the
treated observations hat(Y_it(0)). The difference between treated and
predicted untreated outcomes Y_it(1) - hat(Y_it(0)) serves as an estimate
for the treatment effect for unit i in period t. These are then averaged to
form average treatment effects for groups of {it}.
}
\section{Examples}{


Load example dataset which has two treatment groups and homogeneous treatment effects

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Load Example Dataset
data("df_hom", package="did2s")
}\if{html}{\out{</div>}}
\subsection{Static TWFE}{

You can run a static TWFE fixed effect model for a simple treatment indicator

\if{html}{\out{<div class="sourceCode r">}}\preformatted{did_imputation(data = df_hom, yname = "dep_var", gname = "g",
               tname = "year", idname = "unit")
#> # A tibble: 1 x 6
#>   lhs     term  estimate std.error conf.low conf.high
#>   <chr>   <chr>    <dbl>     <dbl>    <dbl>     <dbl>
#> 1 dep_var treat     2.00    0.0182     1.97      2.04
}\if{html}{\out{</div>}}
}

\subsection{Event Study}{

Or you can use relative-treatment indicators to estimate an event study estimate

\if{html}{\out{<div class="sourceCode r">}}\preformatted{did_imputation(data = df_hom, yname = "dep_var", gname = "g",
               tname = "year", idname = "unit", horizon=TRUE)
#> # A tibble: 21 x 6
#>    lhs     term  estimate std.error conf.low conf.high
#>    <chr>   <chr>    <dbl>     <dbl>    <dbl>     <dbl>
#>  1 dep_var 0         1.97    0.0425     1.89      2.05
#>  2 dep_var 1         2.05    0.0434     1.97      2.14
#>  3 dep_var 2         2.03    0.0432     1.95      2.12
#>  4 dep_var 3         1.97    0.0428     1.88      2.05
#>  5 dep_var 4         1.97    0.0420     1.88      2.05
#>  6 dep_var 5         2.03    0.0423     1.95      2.11
#>  7 dep_var 6         2.04    0.0450     1.95      2.13
#>  8 dep_var 7         2.00    0.0437     1.91      2.08
#>  9 dep_var 8         2.02    0.0440     1.93      2.10
#> 10 dep_var 9         1.96    0.0440     1.87      2.04
#> # ... with 11 more rows
}\if{html}{\out{</div>}}
}

\subsection{Example from Cheng and Hoekstra (2013)}{

Here's an example using data from Cheng and Hoekstra (2013)

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Castle Data
castle <- haven::read_dta("https://github.com/scunning1975/mixtape/raw/master/castle.dta")

did_imputation(data = castle, yname = "c(l_homicide, l_assault)", gname = "effyear",
              first_stage = ~ 0 | sid + year,
              tname = "year", idname = "sid")
#> # A tibble: 2 x 6
#>   lhs        term  estimate std.error conf.low conf.high
#>   <chr>      <chr>    <dbl>     <dbl>    <dbl>     <dbl>
#> 1 l_homicide treat   0.0798    0.0609  -0.0395     0.199
#> 2 l_assault  treat   0.0496    0.0513  -0.0510     0.150
}\if{html}{\out{</div>}}
}
}

