% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfoci.R
\name{mfoci}
\alias{mfoci}
\title{Multivariate feature ordering by conditional independence.}
\usage{
mfoci(
  X,
  Y,
  pre.selected = NULL,
  perm = FALSE,
  perm.method = c("decreasing"),
  autostop = TRUE
)
}
\arguments{
\item{X}{A numeric matrix or data.frame/data.table. Contains the predictor vector X.}

\item{Y}{A numeric matrix or data.frame/data.table. Contains the response vector Y.}

\item{pre.selected}{An integer vector for indexing pre-selected predictor variables from X.}

\item{perm}{A logical. If \code{True} a version of \code{didec} is computed that takes into account the permutations (specified by \code{perm.method}) of the response variables.}

\item{perm.method}{An optional character string specifying a method in \code{didec} for permuting the response variables. This must be one of the strings \code{"sample"}, \code{"increasing"}, \code{"decreasing"} (default) or \code{"full"}. The version \code{"full"} is invariant with respect to permutations of the response variables.}

\item{autostop}{A logical. If \code{True} the algorithm stops at the first non-increasing value of \code{didec}.}
}
\value{
A data.frame listing the selected variables.
}
\description{
A variable selection algorithm based on the directed dependence coefficient (\code{\link{didec}}).
}
\details{
\code{mfoci} is a forward feature selection algorithm for multiple-outcome data that employs the directed dependence coefficient (\code{didec}) at each step.
\code{mfoci} is proved to be consistent in the sense that the subset of predictor variables selected via \code{mfoci} is sufficient with high probability.

If \code{autostop == TRUE} the algorithm stops at the first non-increasing value of \code{didec}, thereby selecting a subset of variables.
Otherwise, all predictor variables are ordered according to their predictive strength measured by \code{didec}.
}
\examples{
library(didec)
data("bioclimatic")
X <- bioclimatic[, c(9:12)]
Y <- bioclimatic[, c(1,8)]
mfoci(X, Y, pre.selected = c(1, 3))
}
\references{
J. Ansari, S. Fuchs, A simple extension of Azadkia & Chatterjee's rank correlation to multi-response vectors, Available at https://arxiv.org/abs/2212.01621, 2024.
}
\author{
Sebastian Fuchs, Jonathan Ansari, Yuping Wang
}
