% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dfrr.R
\name{plot.dfrr}
\alias{plot.dfrr}
\title{Plot a dfrr fit}
\usage{
\method{plot}{dfrr}(x, plot.kernel = TRUE, ...)
}
\arguments{
\item{x}{the output of the function \link{fitted.dfrr}}

\item{plot.kernel}{a boolean indicating whether plots the kernel function or not.
\code{ggplot2}-package and \code{plotly}-package is required to plot contour and 3d surface of kernel function.}

\item{...}{graphical parameters passed to \code{\link{plot.coef.dfrr}}}
}
\value{
This function generates a set of plots, including
functional regression coefficients, principal components, 2-d contour and 3d-surface of kernel function, and QQ-plot of residuals.
}
\description{
Plot the regression coefficients, principal components, kernel function and residuals of a \code{dfrr}-object.
}
\details{
The contour plot of the kernel function is produced if the package \code{ggplot2} is installed.
Plotting the 3d surface  of the kernel function is also depends on the package \code{plotly}.
To produce the qq-plot, the package \code{car} must be installed.
}
\examples{
set.seed(2000)
\donttest{N<-50;M<-24}
\dontshow{N<-30;M<-12}
X<-rnorm(N,mean=0)
time<-seq(0,1,length.out=M)
Y<-simulate_simple_dfrr(beta0=function(t){cos(pi*t+pi)},
                        beta1=function(t){2*t},
                        X=X,time=time)

#The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
dfrr_fit<-dfrr(Y~X,yind=time,T_E=1)
\donttest{plot(dfrr_fit)}
\dontshow{plot(dfrr_fit,plot.kernel=FALSE)}

}
