% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_separation.R, R/zzz_conventions.R
\name{detect_separation_control}
\alias{detect_separation_control}
\alias{detectSeparationControl}
\title{Auxiliary function for the \code{\link{glm}} interface when
\code{method} is \code{\link{detect_separation}}.}
\usage{
detect_separation_control(
  implementation = c("ROI", "lpSolveAPI"),
  solver = "lpsolve",
  linear_program = c("primal", "dual"),
  purpose = c("find", "test"),
  tolerance = 1e-04,
  solver_control = list()
)

detectSeparationControl(
  implementation = c("ROI", "lpSolveAPI"),
  solver = "lpsolve",
  linear_program = c("primal", "dual"),
  purpose = c("find", "test"),
  tolerance = 1e-04,
  solver_control = list()
)
}
\arguments{
\item{implementation}{should the implementation using \code{ROI} or
the implementation using \code{lpSolveAPI} be used? Default is
\code{ROI}.}

\item{solver}{should the linear program be solved using the
\code{"lpsolve"} (using the \pkg{ROI.plugin.lpsolve} package;
default) or another solver? Alternative solvers are
\code{"glpk"}, \code{"cbc"}, \code{"clp"}, \code{"cplex"},
\code{"ecos"}, \code{"gurobi"}, \code{"scs"},
\code{"symphony"}. If \pkg{ROI.plugin.[solver]} is not
installed then the user will be prompted to install it before
continuing.}

\item{linear_program}{should \code{\link{detect_separation}} solve
the \code{"primal"} (default) or \code{"dual"} linear program
for separation detection? Only relevant if \code{implementation
= "lpSolveAPI"}.}

\item{purpose}{should \code{\link{detect_separation}} simply
\code{"test"} for separation or also \code{"find"} (default)
which parameters are infinite? Only relevant if
\code{implementation = "lpSolveAPI"}.}

\item{tolerance}{maximum absolute variable value from the linear
program, before separation is declared. Default is
\code{1e-04}.}

\item{solver_control}{a list with additional control parameters for
the \code{"solver"}. This is solver specific, so consult the
corresponding documentation. Default is \code{list()} unless
\code{solver} is \code{"alabama"} when the default is \code{list(start
= rep(0, p))}, where p is the number of parameters.}
}
\value{
A list with the supplied \code{linear_program}, \code{solver},
\code{solver_control}, \code{purpose}, \code{tolerance},
\code{implementation}, and the matched \code{separator} function
(according to the value of \code{implementation}).
}
\description{
Typically only used internally by \code{\link{detect_separation}}
but may be used to construct a \code{control} argument.
}
