% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stats.R
\name{Froh_inbreeding}
\alias{Froh_inbreeding}
\title{Function to calculated Froh genome-wide or chromosome-wide}
\usage{
Froh_inbreeding(runs, mapFile, genome_wide = TRUE)
}
\arguments{
\item{runs}{R object (dataframe) with results on runs}

\item{mapFile}{Plink map file (to retrieve SNP position)}

\item{genome_wide}{vector of TRUE/FALSE (genome-wide or chromosome-wide;
defaults to TRUE/genome-wide)}
}
\value{
A data frame with the inbreeding coefficients of each individual sample
}
\description{
This function calculates the individual inbreeding coefficients based on runs of
homozygosity (ROH), either per-chromosome (chromosome-wide) or based on the
entire genome (genome-wide). See details of calculations below
}
\details{
Froh is calculated as:

\eqn{ F_{ROH} = \frac{\sum ROH_{length}}{Length_{genome}} }

Depending on whether genome-wide or chromosome-wide calculations are required,
the terms in the numerator and denominator will refer to the entire genome
or will be restricted to specific chromosomes.
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

Froh_inbreeding(runs = runsDF, mapFile = mapFile)
Froh_inbreeding(runs = runsDF, mapFile = mapFile, genome_wide=FALSE)

}
