% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{univariate}
\alias{univariate}
\alias{variance}
\alias{gmean}
\alias{gini}
\alias{stdev}
\alias{madev}
\alias{modval}
\alias{medial}
\alias{kurtosis}
\alias{skewness}
\alias{variance.default}
\alias{gmean.default}
\alias{stdev.default}
\alias{madev.default}
\alias{skewness.default}
\alias{kurtosis.default}
\alias{mean.freq_table}
\alias{gmean.freq_table}
\alias{variance.freq_table}
\alias{stdev.freq_table}
\alias{skewness.freq_table}
\alias{kurtosis.freq_table}
\alias{madev.freq_table}
\alias{modval.freq_table}
\alias{quantile.freq_table}
\alias{median.freq_table}
\alias{medial.freq_table}
\alias{gini.freq_table}
\alias{modval.cont_table}
\alias{gini.cont_table}
\alias{skewness.cont_table}
\alias{kurtosis.cont_table}
\alias{madev.cont_table}
\alias{mean.cont_table}
\alias{variance.cont_table}
\alias{stdev.cont_table}
\title{Functions to compute statistics on univariate distributions}
\usage{
variance(x, ...)

gmean(x, r = 1, ...)

gini(x, ...)

stdev(x, ...)

madev(x, ...)

modval(x, ...)

medial(x, ...)

kurtosis(x, ...)

skewness(x, ...)

\method{variance}{default}(x, w = NULL, ...)

\method{gmean}{default}(x, r = 1, ...)

\method{stdev}{default}(x, w = NULL, ...)

\method{madev}{default}(x, w = NULL, center = c("median", "mean"), ...)

\method{skewness}{default}(x, ...)

\method{kurtosis}{default}(x, ...)

\method{mean}{freq_table}(x, ...)

\method{gmean}{freq_table}(x, r = 1, ...)

\method{variance}{freq_table}(x, ...)

\method{stdev}{freq_table}(x, ...)

\method{skewness}{freq_table}(x, ...)

\method{kurtosis}{freq_table}(x, ...)

\method{madev}{freq_table}(x, center = c("median", "mean"), ...)

\method{modval}{freq_table}(x, ...)

\method{quantile}{freq_table}(x, y = c("value", "mass"), probs = c(0.25, 0.5, 0.75), ...)

\method{median}{freq_table}(x, ..., y = c("value", "mass"))

\method{medial}{freq_table}(x, ...)

\method{gini}{freq_table}(x, ...)

\method{modval}{cont_table}(x, ...)

\method{gini}{cont_table}(x, ...)

\method{skewness}{cont_table}(x, ...)

\method{kurtosis}{cont_table}(x, ...)

\method{madev}{cont_table}(x, center = c("median", "mean"), ...)

\method{mean}{cont_table}(x, ...)

\method{variance}{cont_table}(x, ...)

\method{stdev}{cont_table}(x, ...)
}
\arguments{
\item{x}{a series or a \code{freq_table} or a \code{cont_table} object,}

\item{...}{further arguments,}

\item{r}{the order of the mean for the \code{gmean} function,}

\item{w}{a vector of weights,}

\item{center}{the center value used to compute the mean absolute
deviations, one of \code{"median"} or \code{"mean"},}

\item{y}{for the quantile method, one of \code{"value"} or \code{"mass"},}

\item{probs}{the probabilities for which the quantiles have to be
computed.}
}
\value{
a numeric or a tibble.
}
\description{
\strong{descstat} provide functions to compute statistics on an
univariate distribution. This includes central tendency,
dispersion, shape and concentration.
}
\details{
The following functions are provided:
\itemize{
\item central tendency: \code{mean}, \code{median}, \code{medial}, \code{modval} (for the mode),
\item dispersion: \code{variance}, \code{stdev}, \code{maddev} (for mean absolute
deviation) and quantile,
\item shape: \code{skewness} and \code{kurtosis},
\item concentration: \code{gini}.
}

When a generic function exists in base \strong{R} (or in the \code{stats}
package), methods are provided for \code{freq_table} or \code{cont_table},
this is a case for \code{mean}, \code{median} and \code{quantile}. When a function
exists, but is not generic, we provide a generic and relevant
methods using different names (\code{stdev}, \code{variance} and \code{madev}
instead respectively of \code{sd}, \code{var} and \code{mad}). Finally some
function don't exist in base \strong{R} and recommended packages, we
therefore provide a \code{modval} function to compute the mode, \code{gini}
for the Gini concentration index, \code{skewness} and \code{kurtosis} for
Fisher's shape statistics and \code{gmean} for generalized means (which
include the geometric, the quadratic and the harmonic means).

\code{madev} has a center argument which indicates whether the
deviations should be computed respective to the mean or to the
median.

\code{gmean} has a \code{r} argument: values of -1, 0, 1 and 2 lead
respectively to the harmonic, geometric, arithmetic and quadratic
means.
}
\examples{
library("dplyr")
z <- wages \%>\% freq_table(wage)
z \%>\% median
# the medial is the 0.5 quantile of the mass of the distribution
z \%>\% medial
# the modval function returns the mode, it is a one line tibble
z \%>\% modval
z \%>\% quantile(probs = c(0.25, 0.5, 0.75))
# quantiles can compute for the frequency (the default) or the mass
# of the series
z \%>\% quantile(y = "mass", probs = c(0.25, 0.5, 0.75))
# univariate statistics can be computed on the joint, marginal or
# conditional distributions for cont_table objects
wages \%>\% cont_table(wage, size) \%>\% joint
wages \%>\% cont_table(wage, size) \%>\% marginal(size) \%>\% mean
wages \%>\% cont_table(wage, size) \%>\% conditional(size) \%>\% mean

}
\author{
Yves Croissant
}
\keyword{univar}
