% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate.R
\name{bivariate}
\alias{bivariate}
\alias{covariance}
\alias{correlation}
\alias{covariance.cont_table}
\alias{correlation.cont_table}
\alias{anova.cont_table}
\alias{summary.anova.cont_table}
\alias{regline}
\title{Functions to compute statistics on bivariate distributions}
\usage{
covariance(data, ...)

correlation(data, ...)

\method{covariance}{cont_table}(data, ...)

\method{correlation}{cont_table}(data, ...)

\method{anova}{cont_table}(object, x, ...)

\method{summary}{anova.cont_table}(object, ...)

regline(formula, data)
}
\arguments{
\item{data, object}{a \code{cont_table} object,}

\item{...}{further arguments.}

\item{x}{the series for which the analyse of variance should be
computed,}

\item{formula}{symbolic description of the model,}
}
\value{
a numeric or a tibble
}
\description{
These functions are intended to compute from a \code{cont_table} objects
covariation statistics, ie the covariance, the correlation
coefficient, variance decomposition and regression line.
}
\examples{
# the covariance and the linear correlation coefficient are
# computed using only the `cont_table`
# First reduce the number of bins
wages2 <- wages \%>\%
          dplyr::mutate(size = cut(as_bin(size), c(20, 50, 100)),
                        wage = cut(as_bin(wage), c(10, 30, 50)))
wages2 \%>\% cont_table(wage, size) \%>\% covariance
wages2 \%>\% cont_table(wage, size) \%>\% correlation
# For the analyse of variance, one of the two series should be
# indicated
wages2 \%>\% cont_table(wage, size) \%>\% anova(wage)
wages2 \%>\% cont_table(wage, size) \%>\% anova(wage) \%>\% summary
# For the regression line, a formula should be provided
wages2 \%>\% cont_table(wage, size) \%>\% regline(formula = wage ~ size)
}
\author{
Yves Croissant
}
\keyword{bivariate}
