% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.rank.R
\name{multi.quant}
\alias{multi.quant}
\title{Multivariate Quantile}
\usage{
multi.quant(x, data)
}
\arguments{
\item{x}{A numeric p-variate \code{spatial rank}. Elements must lie within -1 and +1, with a 0-vector denoting the median.}

\item{data}{A matrix or a data.frame with each row as a p-variate observation.}
}
\value{
The \code{x}th mutivariate quantile with respect to \code{data}.
}
\description{
Used to compute the \code{p-variate quantile} of a p-variate observation with respect to a p-variate data cloud.
}
\examples{
u<-matrix(rnorm(90,0,1),ncol=3)
u0<-runif(3,0,1)
multi.quant(spatial.rank(u0,u),u)
}
\author{
Somedip Karmakar <somedip@yahoo.co.in>

Omker Mahalanobish <omker.scorpio@gmail.com>
}
\seealso{
\code{\link{spatial.rank}}
}

