% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{test.point_Bei_MT}
\alias{test.point_Bei_MT}
\title{Perform the test of Bei (2024) simultaneously for multiple time
points.}
\usage{
test.point_Bei_MT(
  r,
  c,
  t,
  par.space,
  data,
  hp,
  verbose = FALSE,
  inst.func.evals = NULL,
  alpha = 0.95,
  parallel = FALSE
)
}
\arguments{
\item{r}{Result of the projection for which the test should be carried out.}

\item{c}{The projection matrix. For now, c is restricted to being an
elementary vector, i.e. c = (0, ...,0, 1, 0, ..., 0).}

\item{t}{The time point at which to evaluate theta. Also allowed to
be a vector of time points (used in estimating the model under assumed time-
independent coefficients).}

\item{par.space}{Matrix containing 2 columns and \eqn{d_\theta} rows, where
\eqn{d_\theta} is the dimension of the parameter space. The first column
represents the lower left corner of the parameter space, the second column
represents the upper right corner. At least for the time being, only
rectangular parameter spaces are allowed.}

\item{data}{Data frame on which to base the test.}

\item{hp}{List of hyperparameters needed.}

\item{verbose}{Boolean variable indicating whether to print updates of the
estimation process to the console.}

\item{inst.func.evals}{Matrix of precomputed instrumental function
evaluations for each observation in the data set. Used to speed up the
simulations. If \code{NULL}, the evaluations will be computed during
execution of this function. Default is \code{inst.func.evals = NULL}.}

\item{alpha}{The significance level at which to perform the test. Default is
\code{alpha = 0.95}.}

\item{parallel}{Flag for whether or not parallel computing should be used.
Default is \code{parallel = FALSE}.}
}
\description{
This function performs the unconditional moment restriction test
as described in Bei (2024). This function directly extends
\code{test.point_Bei} by allowing for pairs of moment restrictions over a
grid of time points.
}
\references{
Bei, X. (2024). Local linearization based subvector inference in
moment inequality models. Journal of Econometrics, 238(1),
105549-. https://doi.org/10.1016/j.jeconom.2023.10554
}
