% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{get.cond.moment.evals}
\alias{get.cond.moment.evals}
\title{Compute the conditional moment evaluations}
\usage{
get.cond.moment.evals(data, beta, t, hp)
}
\arguments{
\item{data}{Data frame.}

\item{beta}{Vector of coefficients.}

\item{t}{Time point of interest.}

\item{hp}{List of hyperparameters.}
}
\value{
A vector of 2n elements containing in the first n positions the
evaluations of 1(Y <= t) - Lambda(X^T beta(t)) and in the last n positions
the evaluations of Lambda(X^T beta(t)) - 1(Y <= t, Delta = 1).
}
\description{
This function computes the 1(Y <= t) - Lambda(X^T beta(t)) and
Lambda(X^T beta(t)) - 1(Y <= t, Delta = 1) parts of the moment functions.
(Used in function get.mi.mat.R)
}
