% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{check.args.pisurv}
\alias{check.args.pisurv}
\title{Check argument consistency.}
\usage{
check.args.pisurv(
  data,
  idx.param.of.interest,
  idxs.c,
  t,
  par.space,
  search.method,
  add.options
)
}
\arguments{
\item{data}{Data frame containing the data on which to fit the model. The
columns should be named as follows: 'Y' = observed timed, 'Delta' = censoring
indicators, 'X0' = intercept column, 'X1' - 'Xp' = covariates.}

\item{idx.param.of.interest}{Index of element in the covariate vector for
which the identified interval should be estimated. It can also be specified
as \code{idx.param.of.interest = "all"}, in which case identified intervals
will be computed for all elements in the parameter vector. Note that
\code{idx.param.of.interest = 1} corresponds to the intercept parameter.}

\item{idxs.c}{Vector of indices of the continuous covariates. Suppose the
given data contains 5 covariates, of which 'X2' and 'X5' are continuous, this
argument should be specified as \code{idxs.c = c(2, 5)}.}

\item{t}{Time point for which to estimate the identified set of
\eqn{\beta(t)}.}

\item{par.space}{Matrix containing bounds on the space of the parameters. The
first column corresponds to lower bounds, the second to upper bounds. The i'th
row corresponds to the bounds on the i'th element in the parameter vector.}

\item{search.method}{The search method to be used to find the identified
interval. Default is \code{search.method = "GS"}.}

\item{add.options}{List of additional options to be specified to the method.
Notably, it can be used to select the link function \eqn{\Lambda(t))} that
should be considered. Currently, the link function leading to an accelerated
failure time model (\code{"AFT_ll"}, default) and the link function
leading to a Cox proportional hazards model (\code{"Cox_wb"}) are implemented.
Other options can range from 'standard' hyperparameters such as the
confidence level of the test and number of instrumental functions to be used,
to technical hyperparameters regarding the search method and test
implementation. For the latter, we refer to the documentations of
\code{set.hyperparameters}, \code{set.EAM.hyperparameters} and
\code{set.GS.hyperparameters}. We recommend to use the default parameters,
unless you really know what you are doing.}
}
\description{
This function checks whether the arguments supplied to the
main estimation function \code{pi.surv} are valid. When arguments are
invalid, the an exception is thrown.
}
