#' @keywords internal

permute_groups <- function(grpSizes, B) {
  k <- length(grpSizes)
  n <- sum(grpSizes)
  M <- factorial(sum(grpSizes)) / prod(factorial(grpSizes))

  if (M <= 10*B){
    results <- list()
    count <- 0

    recursiveAssign <- function(remaining, groupIndex, current) {
      if (count >= B*10) return()

      if (groupIndex > k) {
        results[[length(results) + 1]] <<- current
        count <<- count + 1
      } else {
        combs <- combn(remaining, grpSizes[groupIndex], simplify = FALSE)
        for (comb in combs) {
          if (count >= B*10) return()

          new_current <- c(current, comb)
          new_remaining <- setdiff(remaining, comb)
          new_remaining <- sort(new_remaining)
          recursiveAssign(new_remaining, groupIndex + 1, new_current)
        }
      }
    }

    recursiveAssign(1:n, 1, numeric(0))

    if (length(results) == 0) return(NULL)

    perms <- do.call(rbind, results)
    perms <- perms[sample(nrow(perms)), , drop = FALSE]
    if (M > B) perms <- perms[1:B, ]
    return(perms)
  }
  else{
    original_groups <- rep(1:k, times = grpSizes)
    original_indices <- 1:n

    results <- matrix(NA, nrow = 2*B, ncol = n)

    for (i in 1:(2*B)) {
      permuted_groups <- sample(original_groups)
      permuted_data <- cbind(permuted_groups, original_indices)
      results[i, ] <- permuted_data[order(permuted_data[, 1]), 2]
    }
    results <- results[sample(nrow(results)), , drop = FALSE]
    results <- results[!duplicated(results), , drop = FALSE][1:B, ]

    return(results)
  }
}
