% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kliep.R
\name{kliep}
\alias{kliep}
\title{Kullback-Leibler importance estimation procedure}
\usage{
kliep(
  df_numerator,
  df_denominator,
  scale = "numerator",
  nsigma = 10,
  sigma_quantile = NULL,
  sigma = NULL,
  ncenters = 200,
  centers = NULL,
  cv = TRUE,
  nfold = 5,
  epsilon = NULL,
  maxit = 5000,
  progressbar = TRUE
)
}
\arguments{
\item{df_numerator}{\code{data.frame} with exclusively numeric variables with
the numerator samples}

\item{df_denominator}{\code{data.frame} with exclusively numeric variables
with the denominator samples (must have the same variables as
\code{df_denominator})}

\item{scale}{\code{"numerator"}, \code{"denominator"}, or \code{NULL},
indicating whether to standardize each numeric variable according to the
numerator means and standard deviations, the denominator means and standard
deviations, or apply no standardization at all.}

\item{nsigma}{Integer indicating the number of sigma values (bandwidth
parameter of the Gaussian kernel gram matrix) to use in cross-validation.}

\item{sigma_quantile}{\code{NULL} or numeric vector with probabilities to
calculate the quantiles of the distance matrix to obtain sigma values. If
\code{NULL}, \code{nsigma} values between \code{0.25} and \code{0.75} are
used.}

\item{sigma}{\code{NULL} or a scalar value to determine the bandwidth of the
Gaussian kernel gram matrix. If \code{NULL}, \code{nsigma} values between
\code{0.25} and \code{0.75} are used.}

\item{ncenters}{Maximum number of Gaussian centers in the kernel gram
matrix. Defaults to all numerator samples.}

\item{centers}{Option to specify the Gaussian samples manually.}

\item{cv}{Logical indicating whether or not to do cross-validation}

\item{nfold}{Number of cross-validation folds used in order to calculate the
optimal \code{sigma} value (default is 5-fold cv).}

\item{epsilon}{Numeric scalar or vector with the learning rate for the
gradient-ascent procedure. If a vector, all values are used as the learning
rate. By default, \code{10^{1:-5}} is used.}

\item{maxit}{Maximum number of iterations for the optimization scheme.}

\item{progressbar}{Logical indicating whether or not to display a progressbar.}
}
\value{
\code{kliep}-object, containing all information to calculate the
density ratio using optimal sigma and optimal weights.
}
\description{
Kullback-Leibler importance estimation procedure
}
\examples{
set.seed(123)
# Fit model
dr <- kliep(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
kliep(numerator_small, denominator_small,
      nsigma = 1, ncenters = 100, nfold = 10,
      epsilon = 10^{2:-5}, maxit = 500)
}
\references{
Sugiyama, M., Suzuki, T., Nakajima, S., Kashima, H., Von Bünau, P.,
& Kawanabe, M. (2008). Direct importance estimation for covariate shift
adaptation. \if{html}{\out{<i>}}Annals of the Institute of Statistical Mathematics\if{html}{\out{</i>}}
60, 699-746. Doi: https://doi.org/10.1007/s10463-008-0197-x.
}
