% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PermuteMultiHits.R
\name{PermuteMultiHits}
\alias{PermuteMultiHits}
\title{Permutes x variants across a genelist, and counts genes with multiple hits}
\usage{
PermuteMultiHits(x, y, nperms = 100, class = "lof", geneId = "geneName",
  includeGenes = "all", probTable = pDNM)
}
\arguments{
\item{x}{Total number of de novo variants observed in dataset}

\item{y}{Number of genes with >1 de novo variant (of class "class") in the population}

\item{nperms}{Number permutations}

\item{class}{In c("lof","mis","syn","prot")}

\item{geneId}{Gene identifier used. One of "hgncID", "hgncSymbol",
"enstID", "ensgID" or "geneName" (default, equals ensembl "external_gene_name")}

\item{includeGenes}{Genes to include in analysis. "all" or a vector of gene
names.}

\item{probTable}{Probability table. A user-defined table of probabilities can
be provided here, to replace the probability table included in the package.}
}
\value{
Returns a named vector of 5 values
}
\description{
An internal function called by denovolyzeMultiHits
}
\seealso{
\code{\link{denovolyzeMultiHits}}
}

