% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wuchswerte.R
\name{wuchswerte}
\alias{wuchswerte}
\title{Wuchswerte (Hollstein 1980)}
\usage{
wuchswerte(x)
}
\arguments{
\item{x}{tree-ring series}
}
\value{
tree-ring series normalized according to Hollstein (1980, 14-15)
}
\description{
Function to normalize tree-ring values according to Hollsteins transformation to Wuchswerte (Hollstein 1980, 14-15).
}
\examples{
data(hol_rom)
wuchswerte(hol_rom)
# to convert a rwl object into wuchwerte use:
dplR::as.rwl(apply(hol_rom, 2, wuchswerte))

}
\references{
Hollstein, E. 1980. Mitteleuropäische Eichenchronologie. Trierer Dendrochronologische Forschungen zur Archäologie und Kunstgeschichte. Trierer Grabungen und Forschungen 11. Mainz am Rhein: Verlag Philipp von Zabern.
}
