% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deident.R
\name{deident}
\alias{deident}
\title{Define a transformation pipeline}
\usage{
deident(data, deidentifier, ...)
}
\arguments{
\item{data}{A data frame, existing pipeline, or a 'deidentifier'
(as either initialized object, class generator, or character string)}

\item{deidentifier}{A deidentifier' (as either initialized object,
class generator, or character string) to be appended to the current
pipeline}

\item{...}{Positional arguments are variables of 'data' to be transformed
and key-word arguments are passed to 'deidentifier' at creation}
}
\value{
A 'DeidentList' representing the untrained transformation pipeline.
The object contains fields:
\itemize{
\item \code{deident_methods} a list of each step in the pipeline (consisting of \code{variables} and \code{method})
}

and methods:
\itemize{
\item \code{mutate} apply the pipeline to a new data set
\item \code{to_yaml} serialize the pipeline to a '.yml' file
}
}
\description{
\code{deident()} creates a transformation pipeline of 'deidentifiers' for
the repeated application of  anonymization transformations.
}
\examples{

# 
pipe <- deident(ShiftsWorked, Pseudonymizer, Employee)

print(pipe)

apply_deident(ShiftsWorked, pipe)
  
}
