% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_glossaries.R
\name{list_glossaries}
\alias{list_glossaries}
\title{List All Glossaries from the DeepL API Pro}
\usage{
list_glossaries(auth_key)
}
\arguments{
\item{auth_key}{A string representing the authentication key for the DeepL API Pro. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\description{
\code{list_glossaries} retrieves a list of all glossaries and their metadata associated with your DeepL API Pro account. 
Note that glossary entries themselves are not included.
}
\details{
To use this function, you must obtain an authentication key by registering for a DeepL API Pro account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Pro}.
}
\examples{
\dontrun{
list_glossaries()
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/glossaries#list-all-glossaries}{DeepL API Documentation on Glossaries}
}
