% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{backprop_evaluate}
\alias{backprop_evaluate}
\title{backprop_evaluate function}
\usage{
backprop_evaluate(parameters, dat, truth, net, loss, batchsize, dropout)
}
\arguments{
\item{parameters}{network weights and bias parameters as a vector}

\item{dat}{the input data, a list of vectors}

\item{truth}{the truth, a list of vectors to compare with output from the feed-forward network}

\item{net}{an object of class network, see ?network}

\item{loss}{the loss function, see ?Qloss and ?multinomial}

\item{batchsize}{optional batchsize argument for use with stochastic gradient descent}

\item{dropout}{optional list of dropout probabilities ?dropoutProbs}
}
\value{
the derivative of the cost function with respect to each of the parameters
}
\description{
A function used by the train function in order to conduct backpropagation.
}
\references{
\enumerate{
    \item Ian Goodfellow, Yoshua Bengio, Aaron Courville, Francis Bach. Deep Learning. (2016)
    \item Terrence J. Sejnowski. The Deep Learning Revolution (The MIT Press). (2018)
    \item Neural Networks YouTube playlist by 3brown1blue: \url{https://www.youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi}
    \item{http://neuralnetworksanddeeplearning.com/}
}
}
\seealso{
\link{network}, \link{train}, \link{backprop_evaluate}, \link{MLP_net}, \link{backpropagation_MLP},
\link{logistic}, \link{ReLU}, \link{smoothReLU}, \link{ident}, \link{softmax}, \link{Qloss}, \link{multinomial},
\link{NNgrad_test}, \link{weights2list}, \link{bias2list}, \link{biasInit}, \link{memInit}, \link{gradInit},
\link{addGrad}, \link{nnetpar}, \link{nbiaspar}, \link{addList}, \link{no_regularisation}, \link{L1_regularisation},
\link{L2_regularisation}
}
