#' Deductive correction methods for sign, rounding and typing errors
#' 
#' Deductive correction methods for sign, rounding and typing errors
#' It also contains functionality to check if a matrix of linear restrictions is
#' totally unimodular. See also
#'
#' \itemize{
#' \item{\code{\link{correctRounding}}}
#' \item{\code{\link{correctTypos}}}
#' \item{\code{\link{deducorrect-object}} and \code{\link{status}} for output specification}
#' \item{\code{\link{isTotallyUnimodular}}}
#' \item{\code{\link{deduImpute}}}
#' \item{\code{\link{solSpace}}, \code{\link{imputess}}}
#' \item{\code{\link{deductiveZeros}}}
#' \item{\code{\link{deductiveLevels}}}
#' }
#'
#'
#'
#' @import editrules
#' @importFrom stats complete.cases
#' @importFrom stats addmargins
#' @importFrom methods new
#' @importFrom utils combn
#' @example ../examples/pkg.R
#' @name deducorrect-package 
#' @docType package 
{}



