% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_path-layer.R
\name{add_path_layer}
\alias{add_path_layer}
\title{Add a path layer to the deckgl widget}
\usage{
add_path_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "path-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
The \code{PathLayer} takes in lists of coordinate points and renders them as extruded lines with mitering.
}
\examples{
sample_data <- paste0(
  "https://raw.githubusercontent.com/",
  "uber-common/deck.gl-data/",
  "master/website/bart-lines.json"
)

properties <- list(
  pickable = TRUE,
  widthScale = 20,
  widthMinPixels = 2,
  getPath = ~path,
  getColor = ~color,
  getWidth = 5,
  tooltip = ~name
)

deck <- deckgl(pitch = 25, zoom = 10.5) \%>\%
  add_path_layer(data = sample_data, properties = properties) \%>\%
  add_basemap() \%>\%
  add_control("Path Layer")

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/path-layer}
}
