% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_h3-cluster-layer.R
\name{add_h3_cluster_layer}
\alias{add_h3_cluster_layer}
\title{Add a h3 cluster layer to the deckgl widget}
\usage{
add_h3_cluster_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "h3-cluster-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
Add a h3 cluster layer to the deckgl widget
}
\examples{
## @knitr h3-cluster-layer
data_url <- paste0(
  "https://raw.githubusercontent.com/uber-common/deck.gl-data/",
  "master/website/sf.h3clusters.json"
)
# sample_data <- jsonlite::fromJSON(data_url, simplifyDataFrame = FALSE)
sample_data <- data_url

properties <- list(
  stroked = TRUE,
  filled = TRUE,
  extruded = FALSE,
  getHexagons = ~hexIds,
  getFillColor = JS("d => [255, (1 - d.mean / 500) * 255, 0]"),
  getLineColor = c(255, 255, 255),
  lineWidthMinPixels = 2,
  getTooltip = ~mean
)

deck <- deckgl(zoom = 10.5, pitch = 20) \%>\%
  add_h3_cluster_layer(data = sample_data, properties = properties) \%>\%
  add_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/h3-cluster-layer}
}
