% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_grid-layer.R
\name{add_grid_layer}
\alias{add_grid_layer}
\title{Add a grid layer to the deckgl widget}
\usage{
add_grid_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "grid-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
The \code{GridLayer} renders a grid heatmap based on an array of points. It takes the constant size all each cell, projects points into cells.
The color and height of the cell is scaled by number of points it contains.
}
\examples{
data("sf_bike_parking")

properties <- list(
  filter = "spaces > 4",
  visible = TRUE,
  extruded = TRUE,
  cellSize = 200,
  elevationScale = 4,
  getPosition = "@=[lng, lat]", #~lng + lat,
  colorRange = RColorBrewer::brewer.pal(6, "YlOrRd"),
  tooltip = "{{position.0}}, {{position.1}}<br/>Count: {{count}}"
)

deck <- deckgl(zoom = 11, pitch = 45, bearing = 35, element_id = "grid-layer") \%>\%
  add_source("sf-bike-parking", sf_bike_parking) \%>\%
  add_grid_layer(
    source = "sf-bike-parking",
    properties = properties
  ) \%>\%
  add_control("Grid Layer") \%>\%
  add_basemap() \%>\%
  add_json_editor(wrap = 50, maxLines = 23)

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/grid-layer}
}
