% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R, R/estimate_read_csv_old.R
\name{estimate_read_csv}
\alias{estimate_read_csv}
\alias{estimate_read_csv_old}
\title{Read an Estimate from CSV - File.}
\usage{
estimate_read_csv(fileName, strip.white = TRUE, ...)

estimate_read_csv_old(fileName, strip.white = TRUE, ...)
}
\arguments{
\item{fileName}{Name of the file containing the marginal information of the estimate that 
should be read.}

\item{strip.white}{logical. Used only when \code{sep} has
    been specified, and allows the stripping of leading and trailing
    white space from unquoted \code{character} fields (\code{numeric} fields
    are always stripped).  See \code{\link{scan}} for further details
    (including the exact meaning of \sQuote{white space}),
    remembering that the columns may include the row names.}

\item{...}{Further parameters to be passed to \code{\link[utils]{read.table}}.}
}
\value{
An object of type \code{\link{estimate}} which element \code{$marginal} is read from 
 file \code{fileName} and which element \code{$correlation_matrix} is read from file
 \code{gsub(".csv","_cor.csv",fileName)}.
}
\description{
This function reads an \code{\link{estimate}} from the specified csv files. In this context, an 
estimate of several variables is defined by its marginal distribution types, its marginal
90\%-confidence intervals \code{[lower,upper]} and, optionally, its correlations.

\code{estimate_read_csv_old} reads an estimate from CSV file(s) according to the deprecated 
standard. This function is for backward compatibility only.
}
\details{
An estimate might consists of uncorrelated and correlated variables. This is reflected
  in the input file structure, which is described in the following.
  \subsection{ CSV input file structures}{
  The estimate is read from one or two csv files: the marginal csv file which is mandatory and
  the correlation csv file which is optional. The marginal csv file contains the definition of
  the distribution of all variables ignoring potential correlations. The correlation csv file
  only defines correlations. \subsection{The structure of the marginal distributions input file
  (mandatory)}{
    File name structure: \code{<marginal-filename>.csv}
    
    Mandatory columns:
     \tabular{lll}{
      \bold{Column name}       \tab  \bold{R-type}    \tab \bold{Explanation}\cr
      \code{variable}          \tab  \code{character vector}       \tab  Variable names\cr
      \code{distribution}      \tab  \code{character vector} \tab  Marginal distribution types \cr
      \code{lower}             \tab  \code{numeric vector}   \tab  Marginal 5\%-quantiles \cr
      \code{upper}             \tab  \code{numeric vector}   \tab  Marginal 95\%-quantiles 
     }
     Frequent optional columns are:
     \tabular{lll}{
       \bold{Column name}       \tab  \bold{R-type}              \tab \bold{Explanation}\cr
       \code{description}       \tab  \code{character}           \tab  Short description of the variable.\cr
       \code{median}            \tab  cf. \code{\link{estimate}} \tab  Marginal 50\%-quantiles \cr
       \code{method}            \tab  \code{character vector}    \tab  Methods for calculation of marginal distribution parameters
     }
     Columns without names are ignored. Rows where the \code{variable} field is empty are also dropped.
  }
  \subsection{The structure of the correlation file (optional)}{
     File name structure: \code{<marginal-filename>_cor.csv}
     
     Columns and rows are named by the corresponding variables. Only those variables need to be 
     present which are correlated with others.
     
     The element \code{["rowname","columnname"]} contains the correlation between the variables 
     \code{rowname} and \code{columnname}. Uncorrelated elements have to be set to \code{0}. The
     diagonal element \code{["name","name"]} has to be set to \code{1}.
     
     The matrix must be given in symmetric form.
  }
}

\subsection{Deprecated input standard (\code{estimate_read_csv_old})}{
   File name structure of the correlation file: \code{<marginal-filename>.csv_correlations.csv}\cr
}
}
\examples{
 # Read the joint estimate information for the variables "sales", "productprice" and 
 # "costprice" from file:
 ## Get the path to the file with the marginal information:
 marginalFilePath=system.file("extdata","profit-4.csv",package="decisionSupport")
 ## Read the marginal information from file "profit-4.csv" and print it to the screen as
 ## illustration:
 read.csv(marginalFilePath, strip.white=TRUE)
 ## Read the correlation information from file "profit-4_cor.csv" and print it to the screen as
 ## illustration: 
 read.csv(gsub(".csv","_cor.csv",marginalFilePath), row.names=1)
 ## Now read marginal and correlation file straight into an estimate:
 parameterEstimate<-estimate_read_csv(fileName=marginalFilePath)
 print(parameterEstimate)
}
\seealso{
\code{\link{estimate_write_csv}}, \code{\link[utils]{read.table}}, \code{\link{estimate}}

\code{\link{estimate_read_csv}}, \code{\link[utils]{read.table}}, \code{\link{estimate}}
}
