% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{convert-bases}
\alias{convert-bases}
\alias{deb_convert_bases}
\alias{deb_convert_bases.default}
\alias{deb_convert_bases.deb_lsd}
\alias{deb_convert_bases.deb_decimal}
\alias{deb_convert_bases.deb_tetra}
\title{Convert bases of \code{deb_lsd}, \code{deb_tetra}, and \code{deb_decimal} vectors}
\usage{
deb_convert_bases(x, to)

\method{deb_convert_bases}{default}(x, to)

\method{deb_convert_bases}{deb_lsd}(x, to)

\method{deb_convert_bases}{deb_decimal}(x, to)

\method{deb_convert_bases}{deb_tetra}(x, to)
}
\arguments{
\item{x}{A vector of class \code{deb_lsd}, \code{deb_tetra}, or \code{deb_decimal}.}

\item{to}{Numeric vector of length 2 or 3, representing the bases for the
solidus, denarius, and optionally farthing units to be converted to.}
}
\value{
A vector of the same class as \code{x} with converted \code{bases} attribute.
}
\description{
Convert bases of \code{deb_lsd}, \code{deb_tetra}, and \code{deb_decimal} vectors
}
\details{
\code{deb_convert_bases()} is the only way to change the bases of the solidus,
denarius, and farthing units associated with vectors of class \code{deb_lsd},
\code{deb_tetra}, and \code{deb_decimal}. It also provides a means to convert
between tripartite and tetrapartite bases with \code{deb_decimal} vectors.

If \code{x} is a \code{deb_decimal} vector with tetrapartite bases and unit \code{"f"}
and \code{to} is a numeric vector of length 2, the unit will be converted
to \code{"d"}.
}
\examples{

lsd <- deb_lsd(5, 3, 8)
dec <- deb_decimal(8.825)
dec_tetra <- deb_decimal(1.840625, bases = c(20, 12, 4))
tetra <- deb_tetra(1, 16, 9, 3)

deb_convert_bases(lsd, to = c(60, 16))
deb_convert_bases(dec, to = c(60, 16))
deb_convert_bases(dec_tetra, c(60, 16, 8))
deb_convert_bases(tetra, to = c(60, 16, 8))

# Convert between tripartite and tetrapartite bases
deb_convert_bases(dec, to = c(60, 16, 8))
deb_convert_bases(dec_tetra, to = c(20, 12))

}
