% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcDuration.R
\name{calcDuration}
\alias{calcDuration}
\title{Calculate the study duration based on Weibull distributions.}
\usage{
calcDuration(
  d,
  n,
  proportion,
  SHAPEV,
  SCALEV,
  LAMW,
  A,
  BETA,
  conf.level = 0.9,
  nsim = 10000
)
}
\arguments{
\item{d}{- scalar, target number of events.}

\item{n}{- scalar, sample size.}

\item{proportion}{- vector of percentages of the subgroup.}

\item{SHAPEV}{- vector of shape parameters of Weibull survival distributions of the subgroups.}

\item{SCALEV}{- vector of scale parameters of Weibull survival distributions of the subgroups.}

\item{LAMW}{- vector of exponential drop-out distribution parameters of the subgroups.}

\item{A}{- vector of enrollment durations of the subgroups.}

\item{BETA}{- vector of beta distribution parameters of the subgroups.}

\item{conf.level}{- scalar, confidence level, default 0.9.}

\item{nsim}{- scalar, number of repetitions, default 1e4.}
}
\value{
study duration estimate, d_med, and the confidence interval (d_lower, d_upper), as well as all the realizations, Z_d, of the study duration from the simulation.
}
\description{
Calculate the study duration based on Weibull distributions.
}
\examples{
res_weibull = getWeilbull(dat_udca)
res_beta = getBeta(as.numeric(dat_udca$entry.dt))
prop = c(table(dat_udca$group)/length(dat_udca$group))
SHAPEV = res_weibull$shape
SCALEV = res_weibull$scale
LAMW = rep(-log(1 - 0.1)/6, 4)
A = rep(res_beta$a/30.416, 4) # convert days to months
BETA = rep(res_beta$b_Mean, 4)
myres1 = calcDuration(d=50, n=169, proportion=prop, SHAPEV, SCALEV, LAMW=LAMW, A, BETA)
c(myres1$d_lower, myres1$d_med, myres1$d_upper)
# drop-out will make the target number of events not achievable
myres2 = calcDuration(d=80, n=169, proportion=prop, SHAPEV, SCALEV, LAMW=LAMW, A, BETA)
c(myres2$d_lower, myres2$d_med, myres2$d_upper)
# If there is no drop-out
myres3 = calcDuration(d=80, n=169, proportion=prop, SHAPEV, SCALEV, LAMW=rep(0, 4), A, BETA)
c(myres3$d_lower, myres3$d_med, myres3$d_upper)
}
\references{
Hong Zhang, Jie Pu, Shibing Deng, Satrajit Roychoudhury, Haitao Chu and Douglas Robinson. "Study Duration Prediction for Clinical Trials with Time-to-Event Endpoints Using Mixture Distributions Accounting for Heterogeneous Population", arXiv:2401.00540.
}
