% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.dcsvm.R
\name{plot.dcsvm}
\alias{plot.dcsvm}
\title{Plot Coefficients for Sparse Density-Convoluted SVM}
\usage{
\method{plot}{dcsvm}(x, xvar = c("norm", "lambda"), color = FALSE, label = FALSE, ...)
}
\arguments{
\item{x}{A fitted \code{\link{dcsvm}} model.}

\item{xvar}{Specifies the X-axis. If \code{xvar == "norm"}, plots against the L1-norm of the coefficients; if \code{xvar == "lambda"}, plots against the log-lambda sequence.}

\item{color}{If \code{TRUE}, plots the curves with rainbow colors; otherwise, with gray colors (default).}

\item{label}{If \code{TRUE}, labels the curves with variable sequence numbers. Default is \code{FALSE}.}

\item{...}{Other graphical parameters to \code{plot}.}
}
\value{
No return value, only called for plots.
}
\description{
Plots the solution paths as a coefficient profile plot for a fitted \code{dcsvm} model.
}
\details{
Plot Coefficients for Sparse Density-Convoluted SVM

Plots the solution paths for a fitted \code{\link{dcsvm}} object.


This function generates a coefficient profile plot showing the solution paths of the sparse density-convoluted SVM.
}
\examples{
data(colon)
fit <- dcsvm(colon$x, colon$y)
oldpar <- par(mfrow = c(1,3)) #changes par() and stores original par()
# Plots against the L1-norm of the coefficients
plot(fit)
# Plots against the log-lambda sequence
plot(fit, xvar="lambda", label=TRUE)
# Plots with colors
plot(fit, color=TRUE)
# Reset to user's option
par(oldpar)

}
\seealso{
\code{print.dcsvm}, \code{predict.dcsvm}, \code{coef.dcsvm}, \code{plot.dcsvm}, and \code{cv.dcsvm}.
}
