% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcsvm-package.R
\name{colon}
\alias{colon}
\title{Simplified Gene Expression Data from Alon et al. (1999)}
\source{
The data were introduced in Alon et al. (1999).
}
\usage{
data(colon)
}
\value{
A list with the following elements:
  \item{x}{A matrix of 62 rows and 2000 columns representing the gene expression levels of 62 colon tissue samples. Each row corresponds to a sample, and each column corresponds to a gene.}
  \item{y}{A numeric vector of length 62 representing the tissue type (1 for tumor; -1 for normal).}
}
\description{
This dataset contains 62 colon tissue samples with 2000 gene expression levels. Among these samples, 40 are tumor tissues (coded as 1) and 22 are normal tissues (coded as -1).
}
\details{
Simplified Gene Expression Data from Alon et al. (1999)

Gene expression data (2000 genes for 62 samples) from a DNA microarray experiment of colon tissue samples (Alon et al., 1999).
}
\examples{
# Load the dcsvm library
library(dcsvm)

# Load the dataset
data(colon)

# Check the dimensions of the data
dim(colon$x)

# Count the number of samples in each class
sum(colon$y == -1)
sum(colon$y == 1)

}
\references{
Alon, U., Barkai, N., Notterman, D.A., Gish, K., Ybarra, S., Mack, D., and Levine, A.J. (1999). 
``Broad patterns of gene expression revealed by clustering analysis of tumor and normal colon tissues probed by oligonucleotide arrays,''
\emph{Proceedings of the National Academy of Sciences}, \bold{96}(12), 6745--6750.
}
\keyword{data}
\keyword{set}
