% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enforce_dendritic.R
\name{enforce_dendritic}
\alias{enforce_dendritic}
\title{Enforce dendritic river topology}
\usage{
enforce_dendritic(rivers, correct = TRUE, quiet = FALSE, max_iter = 10)
}
\arguments{
\item{rivers}{A \code{rivers} object returned by \code{\link[=import_rivers]{import_rivers()}}.}

\item{correct}{Logical. If \code{FALSE} (default), no changes are made and
topological issues are identified only. If \code{TRUE}, issues are
automatically corrected.}

\item{quiet}{Logical. If \code{FALSE}, the function prints a summary including
the global DCI and a map of segments. Defaults to \code{TRUE}.}

\item{max_iter}{An integer indicating the maximum number of correction
iterations to run. As some topological errors are corrected new ones can
can arise requiring multiple passes. In some cases, an automated correction
choice can lead to a recursive correction that eliminates most rivers. In
this case, some manual corrections may help avoid this.}
}
\value{
If \code{correct = FALSE}, returns a \code{sf} object with the columns
\code{"divergent"} and \code{"complex"} indicating topological errors. These columns
contain integer identifiers indicating which features are part of the
same divergent or complex structure. If \code{correct = TRUE}, returns a
\code{rivers} object with the topological issues corrected.
}
\description{
Identifies and optionally corrects features in a river network that violate
a strictly dendritic topology.
}
\details{
In a dendritic network, two upstream rivers converge into a single downstream
river at each confluence. This function can enforce this dendritic topology
in a river network by detecting (and optionally correcting) two types of
topological errors: (1) divergences, where a single river splits into
multiple downstream branches (commonly forming loops or braided channels),
and (2) complex confluences, where more than two upstream rivers meet at a
single point.

If errors are being corrected manually, rerun this function again until no
errors remain as correcting divergences can lead to other topological errors
that need to be corrected
}
\examples{
# Import rivers
rivers_in <- import_rivers(yamaska_rivers, quiet = TRUE)

# Correct errors automatically
rivers_cor <- enforce_dendritic(rivers_in, correct = TRUE)

# Return highlighted topological errors for manual correction
rivers_uncor <- enforce_dendritic(rivers_in, correct = FALSE)

# For large river networks it may be better to specify a smaller number of
# correction sweeps.
rivers_cor <- enforce_dendritic(rivers_in, correct = TRUE, max_iter = 3)
}
