% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_dci.R
\name{calculate_dci}
\alias{calculate_dci}
\title{Calculate DCI for a \code{river_net} Object}
\usage{
calculate_dci(
  net,
  form,
  pass = NULL,
  weight = NULL,
  threshold = NULL,
  parallel = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{net}{A \code{\link{river_net}} object.}

\item{form}{A string specifying the DCI form to calculate. Options are:
"pot" for potamodromous or "dia" for diadromous.}

\item{pass}{The name of a column in the nodes table of \code{net} containing
numeric passability values. If \code{NULL}, all barriers are assumed to have 0
passability.}

\item{weight}{The name of a column in the edges table of \code{net} containing
numeric weights for river lengths. If \code{NULL}, DCI is calculated using river
length only.}

\item{threshold}{Optional numeric value specifying a dispersal limit in map
units. If \code{NULL} (default), no limit is applied.}

\item{parallel}{Logical. If \code{FALSE}, the default, all operations are
performed in series. If \code{TRUE} parallel operation is performed using
\code{\link[furrr:future_map2]{furrr::future_pmap()}}. Specify the number of workers and strategy using
\code{\link[future:plan]{future::plan()}}.}

\item{quiet}{Logical. If \code{FALSE}, prints the global DCI and a plot of river
segments to the console. Defaults to \code{TRUE}.}
}
\value{
An \code{sf} object of the river network with new columns specifying
segmental DCI values and relative DCI values. These are each segment's
contribution to the global DCI score which is printed. The relative values
are simply those values normalized.
}
\description{
Calculates the potamodromous and diadromous forms of the Dendritic
Connectivity Index (DCI) for a \code{\link{river_net}} object.
}
\details{
Passability values are probabilities between 0 and 1, where 0 indicates a
fully impassable barrier and 1 indicates full passability. If values in the
specified passability column fall outside this range, they will be
normalized.

Weighting values should also be probabilities between 0 and 1. River segments
with weights of 0 or \code{NA} will be excluded from the DCI calculation.

Upon successful calculation, the global DCI value for the river network will
be printed to the console unless \code{quiet = TRUE}.
}
\examples{
# For the potamodromous DCI
res <- calculate_dci(net = yamaska_net, form = "pot", pass = "pass_1",
weight = "weight")
}
