% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_learning_psoho.R
\name{Velocity}
\alias{Velocity}
\title{R6 class that defines velocities affecting causality lists in the PSO}
\arguments{
\item{n}{the new number of operations that the velocity performs}

\item{probs}{the weight of each value \{-1,0,1\}. They define the probability that each of them will be picked}

\item{seed}{the seed provided to the random number generation}

\item{ps}{a Position object
return the Velocity that gets this position to the new one}

\item{vl}{a Velocity object}

\item{k}{a real number}
}
\description{
Getter of the abs_op attribute.

return the number of operations that the velocity performs

Setter of the abs_op attribute. Intended for inside use only. 
This should be a 'protected' function in Java-like OOP, but there's no 
such thing in R6. This function should not be used from outside the
package.

Randomizes the Velocity's directions. If the seed provided is NULL, no
seed will be used.

Given a position, returns the velocity that gets this position to the
other.

Add both velocities directions

Multiply the Velocity by a constant real number

This function multiplies the Velocity by a constant real number. 
It is non deterministic by definition. When calculating k*|V|, the 
result will be floored and bounded to the set [-max_op, max_op], where max_op
is the maximum number of arcs that can be present in the network.
}
\details{
The velocities will be defined as a causality list where each element in
a causal unit is a pair (v, node) with v being either 0, 1 or -1. 0 means 
that arc remained the same, 1 means that arc was added and -1 means that arc 
was deleted.
}
\section{Fields}{

\describe{
\item{\code{abs_op}}{Total number of operations 1 or -1 in the velocity}
}}

\keyword{internal}
