% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REWarDS.R
\name{fixedTablet}
\alias{fixedTablet}
\title{Fixed tablet}
\usage{
fixedTablet(
  data,
  tablet = 1,
  dspd_qty,
  strength,
  id,
  serv_date,
  tot_dose_disp = NULL,
  Pt_level = FALSE
)
}
\arguments{
\item{data}{Sample simulated data.
Data may have multiple rows per person (one row per prescription fill).
Required columns include:
1. ID: Patient's unique identification number
2. ServDate: Date on which each prescription was filled.
3. DSPD_QTY: Dispensed quantity: Number of tablets dispensed to patient at each prescription fill.
4. strength: Strength of the tablets dispensed.}

\item{tablet}{Number of tablets assumed to be consumed by the patient per day.
Default=1.}

\item{dspd_qty}{Dispensed quantity: Number of the dispensed tablets to the patient
at each prescription fill.}

\item{strength}{Strength of the tablet dispensed in milligrams.}

\item{id}{Unique patient identification number.}

\item{serv_date}{Date of the prescription fill.}

\item{tot_dose_disp}{Total dose dispensed:
dispensed quantity x strength of the tablets dispensed for
each prescription fill.}

\item{Pt_level}{When TRUE, the estimated daily dose and days' supply are averaged
for the patient.}
}
\value{
fixedTablet returns a dataset called "fixedTablet_result". This data set includes all the
variables originally in the data, plus the following:

tot_dose_disp:            Total dose dispensed at prescription fill:
                                  dispensed quantity x strength of the tablet dispensed.

fixed_1_tab_Rx_dose:      Daily dose for prescription.

fixed_1_tab_Rx_DS:        Days' supply for prescription.

fixed_1_tab_Pt_dose:      Average daily dose for patient.

fixed_1_tab_Pt_DS:        Average days' supply for patient.
}
\description{
Computes the daily dose and days' supply for prescriptions by assuming an average
daily consumption of a fixed number of tablets (usually 1) per day by the patient.
}
\details{
The fixed tablet method can be used for any medication.
However, its accuracy has been shown to differ between drug classes.
}
\examples{
#Patient collects 100 tablets of 5 mg warfarin  on January 3rd,
#and 100 tablets of 7 mg warfarin on February 1st.

#Generate a simulated dataset

library(dplyr)
n_patients <- 10
n_records <- 80
data <- data.frame(ID = rep(c(1 : n_patients), each = n_records))
data \%>\%
  group_by(ID) \%>\%
  mutate(ServDate = as.Date('2020/01/01') + abs(round(rnorm(n = 80, 700, 330))),
         DSPD_QTY = abs(round(rnorm(n = 80, 43, 28))),
         strength = abs(round(rnorm(n = 80, 4, 1))))  -> data
data <- as.data.frame(data)

#Assuming consumption of 1 tablet per day:

data_new <- fixedTablet(data, tablet = 1, Pt_level = FALSE, id = "ID",
                        dspd_qty = "DSPD_QTY", strength = "strength",
                        serv_date = "ServDate", tot_dose_disp = NULL)

#tot_dose_disp: 500mg on January 3rd and 700mg for February 1st.
#fixed_1_tab_Rx_dose: 5 mg for the prescription refill on Jan 3rd, 7 mg for prescription
#                     refill on Feb 1st.
#fixed_1_tab_Rx_DS is: For Jan 3rd:  500/5= 100 day;  For Feb 1st: 700/7= 100 days

#pt_level can be set as TRUE to get mean values for each patient
#DDD_1_Pt_dose: (5+ 7)/2 = 6 mg
#DDD_1_Pt_DS: (100+100)/2 = 100 days

}
