% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmine.R
\name{load_sigmine}
\alias{load_sigmine}
\title{SIGMINE - Mining Geographic Information System}
\usage{
load_sigmine(dataset = "sigmine_active", raw_data = FALSE, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("sigmine_active")}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{tibble}.
}
\description{
Loads information the mines being explored legally in Brazil, including their location, status, product being mined and area in square meters.
}
\examples{
\dontrun{
# Download treated data (raw_data = FALSE) in portuguese (language = "pt").
data <- load_sigmine(
  dataset = "sigmine_active",
  raw_data = FALSE,
  language = "pt"
)
}
}
