% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decade.R
\name{plot_decimals}
\alias{plot_decimals}
\title{Plot decimals}
\usage{
plot_decimals(Data, outfile, startyear = NA, endyear = NA)
}
\arguments{
\item{Data}{A character string giving the path of the input file, or
a 5 or 7-column matrix (depending on data type) with following columns: 
variable code, year, month, day, (hour), (minute), value.}

\item{outfile}{Character string giving the path of the output pdf file.}

\item{startyear}{First year to plot. If not indicated, all available years
until \code{endyear} will be plotted.}

\item{endyear}{Last year to plot. If not indicated, all available years
since \code{startyear} will be plotted.}
}
\description{
Plot year-by-year distribution of the decimals
in order to investigate the actual reporting resolution.
}
\details{
The input file must follow the C3S Station Exchange Format (SEF).

Only the first digit after the decimal point is analysed. If there is more
than one digit, the data will be rounded to the first decimal place.
}
\note{
For precipitation and other bounded variables one needs to remove the values
at the boundaries from the input data (e.g., zeros for precipitation).
}
\examples{
plot_decimals(Rosario$Tx, outfile = paste0(tempdir(),"/test.pdf"))

}
\references{
Hunziker et al., 2017: Identifying, attributing, and overcoming common data quality 
issues of manned station observations. Int. J. Climatol, 37: 4131-4145.

Hunziker et al., 2018: Effects of undetected data quality issues on climatological
analyses. Clim. Past, 14: 1-20.
}
\author{
Stefan Hunziker, Yuri Brugnara
}
