% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentiles.R
\name{percentiles_table}
\alias{percentiles_table}
\title{Generate percentiles for entire dataframe}
\usage{
percentiles_table(
  dataset,
  output_filename = "",
  percentiles = c(0:10, seq(10, 90, 10), seq(25, 75, 25), 91:100),
  format_width = TRUE,
  sd_required = TRUE,
  min_required = TRUE,
  max_required = TRUE,
  mean_required = TRUE,
  missing_percentage_required = TRUE,
  class_required = TRUE
)
}
\arguments{
\item{dataset}{A data.frame}

\item{output_filename}{Name of the output excel file (should end in ".xlsx")
Strongly advised to pass this parameter, else the function's default is "percentiles_table_<system_time>.xlsx"}

\item{percentiles}{numeric vector of probabilities with values in [0,100]}

\item{format_width}{Boolean input indicating if output excel cells' column width need to be formatted to "auto"}

\item{sd_required}{Boolean input indicating if standard deviation column needs to be present in output excel}

\item{min_required}{Boolean input indicating if minimum column needs to be present in output excel}

\item{max_required}{Boolean input indicating if maximum column needs to be present in output excel}

\item{mean_required}{Boolean input indicating if mean column needs to be present in output excel}

\item{missing_percentage_required}{Boolean input indicating if missing percentage column needs to be present in output excel}

\item{class_required}{Boolean input indicating if datatype column should be the last column in output excel}
}
\value{
Does not return to calling function, writes to file system rather
}
\description{
This function generates percentiles for all numeric columns in the dataframe.
This will come handy while understanding the distribution of data and in outlier treatment.
}
\examples{
\dontrun{
percentiles_table(mtcars, output_filename = "percentiles_table_mtcars.xlsx")
percentiles_table(iris, output_filename = "C/Users/Desktop/percentiles_table_iris.xlsx")
}
}
