% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableVisual.R
\name{tableVisual}
\alias{tableVisual}
\title{Produce tables for the makeDataReport visualizations.}
\usage{
tableVisual(v, vnam, doEval = TRUE)
}
\arguments{
\item{v}{The variable (vector) to be plotted.}

\item{vnam}{The name of the variable.}

\item{doEval}{If TRUE, the table itself is returned. Otherwise, the function returns
a character string containing standalone R code for producing the table.}
}
\description{
Produce a table of the distribution of a categorical (character, labelled, haven_labelled or factor) variable. 
Note that \code{tableVisual} is a \code{\link{visualFunction}}, compatible with the 
\code{\link{visualize}} and \code{\link{makeDataReport}} functions.
}
\examples{

#Save a variable
myVar <- c("red", "blue", "red", "red", NA) 

#Plot a variable
tableVisual(myVar, "MyVar")

#Produce code for plotting a variable
tableVisual(myVar, "MyVar", doEval = FALSE)

}
\seealso{
\code{\link{visualize}}, \code{\link{basicVisual}}, \code{\link{standardVisual}}
}
