% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_cal.R
\name{col_cal_percent}
\alias{col_cal_percent}
\title{create a new column which is the percentage of other columns}
\usage{
col_cal_percent(df, new_col_name, numerator_cols, denominator_cols)
}
\arguments{
\item{df}{input data frame}

\item{new_col_name}{new column name}

\item{numerator_cols}{numerator columns}

\item{denominator_cols}{denominator columns}
}
\value{
data frame with a new percentage column
}
\description{
create a new column which is the percentage of other columns
}
\examples{
test_df <- data.frame(
  hc1 = c(2, 0, 1, 5, 6, 7, 10),
  hc2 = c(1, 0, 10, 12, 4, 1, 9 ),
  total = c(10, 2, 0, 39, 23, 27, 30)
)
dataMojo::col_cal_percent(test_df,
  new_col_name = "hc_percentage",
  numerator_cols = c("hc1", "hc2"),
  denominator_cols = "total"
)
}
