% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutar.R
\name{mutar}
\alias{mutar}
\alias{filtar}
\alias{sumar}
\alias{withReference}
\title{Tools for Data Frames}
\usage{
mutar(x, i, j, ..., by, sby, drop)

filtar(x, i)

sumar(x, ..., by)

withReference(expr)
}
\arguments{
\item{x}{(DataFrame | data.frame)}

\item{i}{(logical | numeric | integer | OneSidedFormula | TwoSidedFormula |
FormulaList) see the examples.}

\item{j}{(logical | character | TwoSidedFormula | FormulaList | function)
character beginning with '^' are interpreted as regular expression}

\item{...}{arbitrary number of args
\cr in \code{[} (TwoSidedFormulas)
\cr in constructor see \link[tibble]{tibble}}

\item{by}{(character) variables to group by. by will be used to do
transformations within groups. sby will collapse each group to one row.}

\item{sby}{(character) variables to group by. by will be used to do
transformations within groups. sby will collapse each group to one row.}

\item{drop}{(ignored) never drops the class.}

\item{expr}{(expression) any R expression that should be evaluated using data
tables reference semantics on data transformations.}
}
\description{
\code{mutar} is literally the same function as \code{[.DataFrame} and can be
used as interface to dplyr or data.table. Other functions here listed are a
convenience to mimic dplyr's syntax in a \code{R CMD check} friendly way.
These functions can also be used with S4 data.frame(s) / data_frame(s) /
data.table(s). They will always try to preserve the input class.
}
\details{
The real workhorse of this interface is \code{mutar}. All other functions
exist to ease the transition from dplyr.

\code{OneSidedFormula} is always used for subsetting rows.

\code{TwoSidedFormula} is used instead of name-value expressions. Instead of
  writing \code{x = 1} you simply write \code{x ~ 1}.

\code{FormulaList} can be used to repeat the same operation on different
  columns. See more details in \link{FL}.
}
\examples{
data("airquality")
airquality \%>\%
  filtar(~Month > 4) \%>\%
  mutar(meanWind ~ mean(Wind), by = "Month") \%>\%
  sumar(meanWind ~ mean(Wind), by = "Month") \%>\%
  extract("meanWind")

airquality \%>\%
  sumar(
    .n ~ mean(.n) | c("Wind", "Temp"),
    by = "Month"
  )

# Enable data.tables reference semantics with:
withReference({
  x <- data.table::data.table(x = 1)
  mutar(x, y ~ 2)
})

\dontrun{
# Use dplyr as back-end:
options(dat.use.dplyr = TRUE)
x <- data.frame(x = 1)
mutar(x, y ~ dplyr::n())
}

}
\seealso{
\link{extract}, \link{DataFrame}, \link{FL}
}
