% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.keep.loc.r
\name{gl.keep.loc}
\alias{gl.keep.loc}
\title{Removes all but the specified loci from a genlight object}
\usage{
gl.keep.loc(x, loc.list = NULL, first = NULL, last = NULL, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{loc.list}{A list of loci to be kept
[required, if loc.range not specified].}

\item{first}{First of a range of loci to be kept
[required, if loc.list not specified].}

\item{last}{Last of a range of loci to be kept
[if not specified, last locus in the dataset].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress but not results; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
A genlight object with the reduced data
}
\description{
This function deletes loci that are not specified to keep, and their associated metadata. 

The script returns a dartR genlight object with the retained loci. 
The script works with both genlight objects
containing SNP genotypes and Tag P/A data (SilicoDArT).
}
\examples{
# SNP data
  gl2 <- gl.keep.loc(testset.gl, loc.list=c('100051468|42-A/T', '100049816-51-A/G'))
# Tag P/A data
  gs2 <- gl.keep.loc(testset.gs, loc.list=c('20134188','19249144'))
}
\seealso{
\code{\link{gl.drop.loc}} to drop rather than keep specified loci

Other dartR-base: 
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.ind}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.read.dart}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.set.verbosity}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{dartR-base}
