% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.overshoot.r
\name{gl.filter.overshoot}
\alias{gl.filter.overshoot}
\title{Filters loci for which the SNP has been trimmed from the sequence tag
along with the adaptor}
\usage{
gl.filter.overshoot(x, save2tmp = FALSE, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A new genlight object with the recalcitrant loci deleted
}
\description{
This function checks the position of the SNP within the trimmed sequence tag
and identifies those for which the SNP position is outside the trimmed
 sequence tag. This can happen, rarely, when the sequence containing the SNP
 resembles the adaptor.

The SNP genotype can still be used in most analyses, but functions like
gl2fasta() will present challenges if the SNP has been trimmed from the
sequence tag.

Not fatal, but should apply this filter before gl.filter.secondaries, for
obvious reasons.
}
\examples{
result <- gl.filter.overshoot(testset.gl, verbose=3)
}
\seealso{
Other filter functions: 
\code{\link{gl.filter.allna}()},
\code{\link{gl.filter.callrate}()},
\code{\link{gl.filter.heterozygosity}()},
\code{\link{gl.filter.hwe}()},
\code{\link{gl.filter.locmetric}()},
\code{\link{gl.filter.maf}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.pa}()},
\code{\link{gl.filter.parent.offspring}()},
\code{\link{gl.filter.rdepth}()},
\code{\link{gl.filter.reproducibility}()},
\code{\link{gl.filter.secondaries}()},
\code{\link{gl.filter.sexlinked}()},
\code{\link{gl.filter.taglength}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{filter functions}
